/*
********************************************************************************
*	
*   Copyright (c) 2017 by Industrial Control Communications, Inc.
*
*   This software is copyrighted by and is the sole property of
*   Industrial Control Communications, Inc.  Any unauthorized use,
*   duplication, transmission, distribution, or disclosure of this
*   software is expressly forbidden.
*
*   This Copyright notice may not be removed or modified without prior
*   written consent of Industrial Control Communications, Inc.
*
*   ICC, Inc.
*   230 Horizon Dr                      	USA 608.831.1255
*   Suite 100                               http://www.iccdesigns.com
*   Verona, WI 53593                     	support@iccdesigns.com
*
********************************************************************************
*
*          Project: SpiLinuxExample
*        File Name: IccSpiProtocol.h
*    Original Date: 08.24.2017
*           Author: Josh Schulze
*
*      Description: Provides definitions for the ICC SPI protocol.
*
*
*   Edit Date           Edit Description
*   ===============     ========================================================
*   
*
********************************************************************************
*/

#ifndef ICC_SPI_PROTOCOL_H
#define ICC_SPI_PROTOCOL_H

/*
********************************************************************************
*                                   INCLUDES
********************************************************************************
*/

#include <stdint.h>

/*
********************************************************************************
*                                    MACROS
********************************************************************************
*/

#define SPI_PACKET_LEN			5

/* --- SPI Error Codes --- */
#define	SPI_ERR_INVALID_ADDR	0xF0
#define	SPI_ERR_DATA_ERROR		0xF1
#define	SPI_ERR_WR_TO_RO		0xF2
#define	SPI_ERR_RD_FROM_WO		0xF3
#define	SPI_ERR_INVALID_FUNC	0xFB
#define	SPI_ERR_INVALID_PKT		0xFC

/* --- Timing Parameters --- */
#define SPI_MAX_FREQUENCY		5000000		// The maximum supported clock frequency, in hertz
#define SPI_T_DESELECT_US		150			// This is the minimum time (in microseconds) the chip select signal must be held high (deselected) before being asserted low (selected)

/*
********************************************************************************
*                                   TYPE DEFS
********************************************************************************
*/

typedef enum spi_states
{
	SPI_STATE_RESET,
	SPI_STATE_BUSY,
	SPI_STATE_READY,
	SPI_STATE_OPERATION_COMPLETE
} SpiStates;

typedef enum spi_commands
{
	SPI_CMD_GET_STATUS	= 0x01,
	SPI_CMD_SET_ADDR	= 0x11,
	SPI_CMD_READ_BYTE	= 0x21,
	SPI_CMD_READ_SHORT	= 0x22,
	SPI_CMD_READ_LONG	= 0x24,
	SPI_CMD_WRITE_BYTE	= 0x41,
	SPI_CMD_WRITE_SHORT	= 0x42,
	SPI_CMD_WRITE_LONG	= 0x44
} SpiCommands;

typedef struct spi_status_reg
{
	uint8_t 	ack:1;
	uint8_t 	err:1;
	uint8_t 	reservered:4;
	SpiStates 	state:2;
} SpiStatusReg;

/*
********************************************************************************
*                               PUBLIC PROTOTYPES
********************************************************************************
*/

void BuildIccSpiGetStatus (uint8_t *buffer);

void BuildIccSpiSetAddress (uint8_t *buffer, uint16_t address);

void BuildIccSpiRead (uint8_t *buffer, uint8_t numBytes);

void BuildIccSpiWrite (uint8_t *buffer, uint8_t numBytes, uint32_t writeData);

void GetIccSpiResponseData (uint8_t *buffer, SpiStatusReg *status, uint32_t *data);

#endif /* ICC_SPI_PROTOCOL_H */
